classdef class_REVS_HIL_engine
	%UNTITLED6 Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
				
		name = '';
		combustion_type;										% Combustion type specified via enum_engine_combustion_type
		displacement_L;											% Engine displacement [liters]
		inertia_kgm2;											% Engine rotational inertia [kg*m^2]
		idle_speed_radps;
		
		full_throttle_speed_radps;								% Maximum torque curve speed breakpoints [rad/sec]
		full_throttle_torque_Nm;								% Maximum torque curve [Nm]
      
		closed_throttle_speed_radps;							% Closed throttle (Motoring) torque curve speed breakpoints [rad/sec]
		closed_throttle_torque_Nm ;								% Closed throttle (Motoring) torque curve [Nm]
        
		pedal_map_type;											% Generic or custom accelerator pedal to torque mapping
		pedal_map_speed_radps;									% Accelerator pedal to torque map speed breakpoints [radians/sec]
		pedal_map_pedal_norm;									% Accelerator pedal to torque map pedal breakpoints [0 - 1]
		pedal_map_torque_Nm;											% Accelerator pedal to torque map [Nm]
		
		fuel_map_speed_radps;									% Fuel consumption map speed breakpoints [rad/sec]
		fuel_map_torque_Nm										% Fuel consumption map torque breakpoints [Nm]
		fuel_map_gps;											% Fuel consumption map [g/sec]
		      
        
        torque_mode_proportional_gain = 0.75;
        torque_mode_integral_gain = 0.05;
        torque_mode_integral_limit = 50;
        torque_mode_fade_out_secs = 0.5;
                        
    end
	
    
    properties( Hidden = true)
    		
										
 
    
    end
	
	
	properties ( Dependent = true, SetAccess = immutable, Transient = true)
		
		full_throttle_power_W;
		
		
	end
	
	
	
	methods
		
		
		
		
		function val = max_torque_Nm(obj)
			val = max( obj.full_throttle_torque_Nm );
		end
		
		function val = 	min_torque_Nm(obj)
			val = min( obj.closed_throttle_torque_Nm );
		end
		
		function val = get.full_throttle_power_W(obj)
			val = obj.full_throttle_speed_radps .* obj.full_throttle_torque_Nm;
		end
						
		function val = get.pedal_map_torque_Nm(obj)
				
			if isempty(obj.pedal_map_type) || obj.pedal_map_type == enum_engine_pedal_map_type.lookup_table
				val = obj.pedal_map_torque_Nm ;
			else
				
				zero_pedal_torque_Nm = zeros(length(obj.full_throttle_speed_radps),1);
				full_pedal_torque_Nm = obj.full_throttle_torque_Nm(:) - min(0, interp1(obj.closed_throttle_speed_radps(:), obj.closed_throttle_torque_Nm(:), obj.full_throttle_speed_radps(:),'linear','extrap'));
				
				obj.pedal_map_pedal_norm =  [0 1];
				%obj.pedal_map_speed_radps = obj.full_throttle_speed_radps;
				
				switch( obj.pedal_map_type)
					
					case  enum_engine_pedal_map_type.linear_WOT
						val = [zero_pedal_torque_Nm, full_pedal_torque_Nm]';
					case enum_engine_pedal_map_type.linear_max_engine_torque
						val = [zero_pedal_torque_Nm, max(full_pedal_torque_Nm)*ones(size(full_pedal_torque_Nm))]';
					case enum_engine_pedal_map_type.max_engine_power
						val = [zero_pedal_torque_Nm, obj.max_power_W ./ max(100,  obj.full_throttle_speed_radps(:))]';
					case enum_engine_pedal_map_type.linear_enhanced_WOT
						val = [zero_pedal_torque_Nm, 1.1 * full_pedal_torque_Nm]';
					case enum_engine_pedal_map_type.linear_enhanced_max_engine_torque
						val = [zero_pedal_torque_Nm, 1.1 * max(full_pedal_torque_Nm)*ones(size(full_pedal_torque_Nm))]';
					otherwise
						val = [];
				end
			end
			
		end
		
		
		function val = get.pedal_map_pedal_norm(obj)
			
			if isempty(obj.pedal_map_type) || obj.pedal_map_type == enum_engine_pedal_map_type.lookup_table;	
				val = obj.pedal_map_pedal_norm;
			else
				val =  [0 1];
			end
			% Handle undefined pedal map types
			
		end
		
		function val = get.pedal_map_speed_radps(obj)
			
			if isempty(obj.pedal_map_type) || obj.pedal_map_type == enum_engine_pedal_map_type.lookup_table ;	
				val = obj.pedal_map_speed_radps;
			else
				val =  obj.full_throttle_speed_radps;
			end
			% Handle undefined pedal map types
			
		end
		
		
		function [trq, spd] = full_throttle_hires_torque( obj)
			spd = 0:0.1:obj.full_throttle_speed_radps(end);
			trq = interp1( obj.full_throttle_speed_radps, obj.full_throttle_torque_Nm, spd );
		end
		
		
		function val = max_power_W(obj)
			[trq, spd] = obj.full_throttle_hires_torque;
			val = max( spd .* trq );
			
		end
		
		function val = max_power_max_radps(obj)
			[trq, spd] = obj.full_throttle_hires_torque;
			
			power_W = spd .* trq ;
			idx =  find( power_W > max(power_W) * 0.98,1,'last');
			val = spd(idx);
		end
		
		function val = max_power_max_rpm(obj)
			val = obj.max_power_max_radps .* convert.radps2rpm;
		end
		
		
		function val = max_power_min_radps(obj)
			[trq, spd] = obj.full_throttle_hires_torque;
			
			power_W = spd .* trq ;
			idx =  find( power_W > max(power_W) * 0.98,1,'first');
			val = spd(idx);
			
		end
		
		function val = max_power_min_rpm(obj)
			val = obj.max_power_min_radps .* convert.radps2rpm;
		end
		
		function val = max_power_avg_radps(obj)
			[trq, spd] = obj.full_throttle_hires_torque;
			idx1 =  find( power_W > max(power_W) * 0.98,1,'last');
			idx2 =  find( power_W > max(power_W) * 0.98,1,'first');
			val = mean(spd([idx1,idx2]));
		end
		
		function val = max_power_avg_rpm(obj)
			val = obj.max_power_avg_radps .* convert.radps2rpm;
		end
		
	end
	
end

